/* $Header: svn://svn.omnis.net/branches/Studio10.2/Omnis_Master/CrossPlatform/jsworker/omnis_modules.js 31889 2022-11-24 11:51:09Z aaugustin $ */
// Contains the Omnis JavaScript worker module map
// Copyright (C) OLS Holdings Ltd 2018

/*********************************** Changes History **********************************
Date			Edit				Bug					Description
28-Mar-19	jmg_unmarked						Updated to use local package for omnis_test.
11-Mar-19	jmg_unmarked						Simplified structure of this file + added error handling around missing module.
21-Nov-18	rmm_jsw									OW3 component - JavaScript Worker.
**************************************************************************************/


// Map of modules that can be called
// Each member of the object is a module name that can be used as the module parameter to $callmethod
const moduleMap = {
	test: require('omnis_test')
};

const omnis_modules = {

	call: function (module, method, param, response) {
		if (moduleMap[module])
			return moduleMap[module].call(method, param, response);
		else
			throw new Error("Module '" + module + "' not found")
	}

};

module.exports = omnis_modules;
